/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.swing;

import java.awt.*;
import javax.swing.*;

/**
 * The small dialog allowing the user to enter the username and password.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public class UserPasswdPanel extends JPanel {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField usernameTF = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel1 = new JPanel();
    JPasswordField passwdTF = new JPasswordField();

    public UserPasswdPanel() {
        try {
            jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(gridBagLayout1);
        jLabel1.setText("Username:");
        jLabel2.setText("Password:");
        usernameTF.setText("");
        this.setBorder(null);
        passwdTF.setText("");
        this.add(usernameTF,     new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 5, 3, 6), 0, 0));
        this.add(jLabel1,    new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 5, 3, 6), 0, 0));
        this.add(jLabel2,    new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 5, 3, 6), 0, 0));
        this.add(jPanel1,      new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        this.add(passwdTF,    new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 5, 3, 6), 0, 0));
    }

    public void initUserLogin(JComponent label, JComponent prompt, String username,
                              boolean mayChangeUsername) {
        this.add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 5, 8, 6), 0, 0));
        this.add(prompt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(2, 5, 8, 6), 0, 0));
        usernameTF.setText(username);
        usernameTF.setEnabled(mayChangeUsername);
        passwdTF.setText("");
    }


    public String getUsername() {
        return usernameTF.getText();
    }

    public char[] getPassword() {
        return passwdTF.getPassword();
    }

    public static Object[] askUserAndPassword(Component parent, String title, Object label, Object prompt,
                                              String user, boolean mayChangeUsername) {
        UserPasswdPanel panel = new UserPasswdPanel();
        if (!(label instanceof JComponent)) {
            label = new JLabel(label.toString());
        }
        if (!(prompt instanceof JComponent)) {
            prompt = new JLabel(prompt.toString());
        }
        panel.initUserLogin((JComponent)label, (JComponent)prompt, user, mayChangeUsername);
        return askPassword(parent,title, panel);
    }


    private static Object[] askPassword(Component parent, String title, UserPasswdPanel panel) {
        int option = JOptionPane.showConfirmDialog(parent, panel, title,
            JOptionPane.OK_CANCEL_OPTION , JOptionPane.QUESTION_MESSAGE);
        if (option != JOptionPane.OK_OPTION) return null;
        return new Object[] { panel.getUsername(), panel.getPassword() };
    }
}
